<?php
include('config/config.php'); 

// Verifica se o formulário foi submetido
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Recupera os dados do formulário e remove caracteres perigosos
    $nome = htmlspecialchars($_POST['nome']);
    $email = htmlspecialchars($_POST['email']);
    $telefone = htmlspecialchars($_POST['fone']);
    $cidade = htmlspecialchars($_POST['cidade']);
    $area_atuacao = htmlspecialchars($_POST['area_atuacao']);

    // Verifica se o telefone ou email já existem no banco
    $sql_check = "SELECT COUNT(*) as count FROM dados_formulario WHERE telefone = ? OR email = ?";
    $stmt_check = $conexao->prepare($sql_check);
    $stmt_check->bind_param("ss", $telefone, $email);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    $row_check = $result_check->fetch_assoc();

    if ($row_check['count'] > 0) {
        // Telefone ou email já existem no banco, não fazer o cadastro
        $notificacao = "Telefone ou email já cadastrado.";
    } else {
        // Prepara a consulta SQL para inserir os dados usando prepared statements
        $sql_insert = "INSERT INTO dados_formulario (nome, email, telefone, cidade, area_atuacao) VALUES (?, ?, ?, ?, ?)";
        $stmt_insert = $conexao->prepare($sql_insert);

        // Associa os valores dos parâmetros aos placeholders na consulta SQL
        $stmt_insert->bind_param("sssss", $nome, $email, $telefone, $cidade, $area_atuacao);

        // Executa a consulta SQL
        if ($stmt_insert->execute()) {
            // Redireciona para uma página de sucesso ou exibe uma mensagem de sucesso
            header("Location:https://mixksolutions.com.br/checkout/?item=4");
            exit;
        } else {
            echo "Erro ao inserir dados: " . $stmt_insert->error;
        }

        // Fecha o statement de inserção
        $stmt_insert->close();
    }

    // Fecha o statement de verificação
    $stmt_check->close();
}

// Fecha a conexão com o banco de dados
$conexao->close();
?>

